/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.block.entity;

import me.ultrusmods.missingwilds.ColorSets;
import me.ultrusmods.missingwilds.particle.FireflyParticleOptions;
import me.ultrusmods.missingwilds.register.MissingWildsBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FireflyJarBlockEntity
extends BlockEntity
implements Nameable {
    private int color = 7601920;
    private Component name;

    public FireflyJarBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(MissingWildsBlockEntities.FIREFLY_JAR.get(), blockPos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("color")) {
            this.color = tag.m_128451_("color");
        }
        if (tag.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("color", this.color);
        if (this.name != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }

    public Component m_7755_() {
        return this.name;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void mixColor(int color) {
        int curRed = this.color >> 16 & 0xFF;
        int curGreen = this.color >> 8 & 0xFF;
        int curBlue = this.color & 0xFF;
        int newRed = color >> 16 & 0xFF;
        int newGreen = color >> 8 & 0xFF;
        int newBlue = color & 0xFF;
        int red = (curRed + newRed) / 2;
        int green = (curGreen + newGreen) / 2;
        int blue = (curBlue + newBlue) / 2;
        this.color = Mth.m_14103_((int)red, (int)green, (int)blue);
        this.m_6596_();
    }

    public void createParticles(Level level, int lightLevel, BlockPos pos, RandomSource random) {
        ColorSets.ColorSet colorSet = null;
        if (this.name != null) {
            colorSet = ColorSets.COLOR_SETS.get(this.name.getString());
        }
        for (int i = 0; i < lightLevel / 2; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (2.0 * random.m_188500_() - 1.0);
            double y = (double)pos.m_123342_() + 0.5 + (double)(random.m_188503_(3) + 1);
            double z = (double)pos.m_123343_() + 0.5 + (2.0 * random.m_188500_() - 1.0);
            this.spawnFireflies(level, random, colorSet, x, y, z, 0.0075f);
        }
    }

    public void createInnerParticles(Level level, int lightLevel, BlockPos pos, RandomSource random) {
        ColorSets.ColorSet colorSet = null;
        if (this.name != null) {
            colorSet = ColorSets.COLOR_SETS.get(this.name.getString());
        }
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (2.0 * random.m_188500_() - 1.0) / 5.0;
            double y = (double)pos.m_123342_() + 0.5 + (2.0 * random.m_188500_() - 1.0) / 4.0;
            double z = (double)pos.m_123343_() + 0.5 + (2.0 * random.m_188500_() - 1.0) / 5.0;
            this.spawnFireflies(level, random, colorSet, x, y, z, 0.0f);
        }
    }

    private void spawnFireflies(Level level, RandomSource random, ColorSets.ColorSet colorSet, double x, double y, double z, float speed) {
        if (colorSet != null) {
            Integer[] color = colorSet.colors[random.m_188503_(colorSet.colors.length)];
            level.m_7106_((ParticleOptions)new FireflyParticleOptions((float)color[0].intValue() / 255.0f, (float)color[1].intValue() / 255.0f, (float)color[2].intValue() / 255.0f, 0.5f, speed), x, y, z, 0.0, 0.0, 0.0);
        } else {
            double[] color = this.getColorArr();
            level.m_7106_((ParticleOptions)new FireflyParticleOptions(color[0], color[1], color[2], 0.5f, speed), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public double[] getColorArr() {
        return new double[]{(double)(this.color >> 16 & 0xFF) / 255.0, (double)(this.color >> 8 & 0xFF) / 255.0, (double)(this.color & 0xFF) / 255.0};
    }

    public int getColor() {
        return this.color;
    }

    public Component m_7770_() {
        return this.name;
    }
}

